<?php
global $title, $hook_suffix, $current_screen, $wp_locale, $pagenow, $wp_version,
		$update_title, $total_update_count, $parent_file, $swift_performance_setup;

		$current 	= $swift_performance_setup->current_step['index'];
		$current_id	= (isset($swift_performance_setup->current_step['id']) ? $swift_performance_setup->current_step['id'] : 'start-wizard');

		$swift_performance_purchase_key = Swift_Performance::get_option('purchase-key');

		$scores = get_option('swift-performance-pagespeed-scores');
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head>
	<meta name="viewport" content="width=device-width" />
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><?php wp_title();?></title>
	<?php do_action( 'swift_performance_setup_enqueue_scripts' ); ?>
	<?php do_action( 'admin_print_styles' ); ?>
	<?php do_action( 'admin_print_scripts' );?>
	<?php do_action( 'admin_head' ); ?>
</head>
<body class="wp-core-ui<?php echo esc_attr(' swift-setup-' . $current_id);?><?php echo(!empty($swift_performance_purchase_key) ? ' swift-setup-activated' : '')?>">
	<ul class="swift-setup-steps">
		<?php foreach ($swift_performance_setup->steps as $key => $step):?>
		<li<?php echo ($key == $swift_performance_setup->current_step['index'] ? ' class="active"' : ($key > $swift_performance_setup->current_step['index'] ? ' class="disabled"' : ''))?>>
			<?php echo esc_html($step['title']); ?>
		</li>
		<?php endforeach;?>
	</ul>
	<div class="swift-setup-wrapper">
		<form method="post" id="swift-setup-form" action="<?php echo esc_url(wp_nonce_url(add_query_arg(array('subpage' => 'setup', 'step' => ($current+1)), menu_page_url('swift-performance', false)), 'swift-performance-setup', 'swift-nonce'));?>">
