<?php if ( count( $sshares ) === 0 ){ ?>

	<?php $this->render("admin/sshare/welcome", array(
        'new_url' => $add_new_url,
        'user_name' => $user_name
    )); ?>

<?php } else { ?>

	<main id="wpmudev-hustle" class="wpmudev-ui wpmudev-hustle-listings-view">

        <header id="wpmudev-hustle-title" class="wpmudev-has-button">

			<h1><?php _e( "Social Sharing Dashboard", Opt_In::TEXT_DOMAIN ); ?></h1>

			<a class="wpmudev-button wpmudev-button-sm wpmudev-button-ghost" href="<?php echo esc_url( $add_new_url ); ?>"><?php _e('New Sharing Module', Opt_In::TEXT_DOMAIN); ?></a>

        </header>

        <section id="wpmudev-hustle-content">

            <?php foreach( $sshares as $sshare ) :

                $keep_open = ( count( $sshares ) === 1 ) ? true : false;

                if ( !$keep_open && $new_module && $sshare->id === $new_module )
                    $keep_open = true;

                if ( !$keep_open && $updated_module && $sshare->id === $updated_module )
                    $keep_open = true; ?>

                <div class="wpmudev-row">

                    <div class="wpmudev-col col-12">

                        <div class="wpmudev-box-listing">

							<div class="wpmudev-box-head">

                                <div class="wpmudev-box-group">

									<div class="wpmudev-box-group--inner">

										<div class="wpmudev-group-switch">

											<div class="wpmudev-switch">

												<input id="social-sharing-active-toggle-<?php echo esc_attr( $sshare->id ); ?>" class="social-sharing-toggle-activity" type="checkbox" data-id="<?php echo esc_attr( $sshare->id ); ?>" <?php checked( $sshare->active, 1 ); ?> data-nonce="<?php echo wp_create_nonce('sshare_module_toggle_state') ?>">

												<label class="wpmudev-switch-design" for="social-sharing-active-toggle-<?php echo esc_attr( $sshare->id ); ?>" aria-hidden="true"></label>

											</div><?php // .wpmudev-switch ?>

										</div>

										<div class="wpmudev-group-title">

											<h5><?php echo $sshare->module_name; ?></h5>

										</div>

										<div class="wpmudev-group-buttons">

											<a class="wpmudev-button wpmudev-button-sm hustle-edit-module" href="<?php echo $sshare->decorated->get_edit_url( Hustle_Module_Admin::SOCIAL_SHARING_WIZARD_PAGE ,'' ); ?>">
												<span class="wpmudev-button-icon"><?php $this->render("general/icons/admin-icons/icon-edit" ); ?></span>
												<span class="wpmudev-button-text"><?php _e('Edit', Opt_In::TEXT_DOMAIN); ?></span>
											</a>

											<a class="wpmudev-button wpmudev-button-sm wpmudev-button-red hustle-delete-module" data-nonce="<?php echo wp_create_nonce('hustle_delete_module'); ?>" data-id="<?php echo esc_attr( $sshare->id ); ?>" >
												<span class="wpmudev-button-icon"><?php $this->render("general/icons/admin-icons/icon-delete" ); ?></span>
												<span class="wpmudev-button-text"><?php _e('Delete', Opt_In::TEXT_DOMAIN); ?></span>
                                            </a>

										</div>

									</div>

								</div>

								<div class="wpmudev-box-action"><?php $this->render("general/icons/icon-arrow" ); ?></div>

                            </div><?php // .wpmudev-box-head ?>

                            <div class="wpmudev-box-body <?php echo $keep_open ? '' : 'wpmudev-hidden'; ?>">

								<div class="wpmudev-box-<?php echo $sshare->active ? 'enabled' : 'disabled'; ?>">

									<label class="wpmudev-helper"><?php _e("Please activate this social sharing to configure it's settings.", Opt_In::TEXT_DOMAIN); ?></label>

								</div>

								<div class="wpmudev-listing">

									<div class="wpmudev-listing-head" aria-hidden="true">

                                        <div class="wpmudev-listing-type"><?php _e( "Module type", Opt_In::TEXT_DOMAIN ); ?></div>

										<div class="wpmudev-listing-conditions"><?php _e( "Display conditions", Opt_In::TEXT_DOMAIN ); ?></div>

										<div class="wpmudev-listing-views"><?php _e( "Views", Opt_In::TEXT_DOMAIN ); ?></div>

										<div class="wpmudev-listing-conversions"><?php _e( "Conversions", Opt_In::TEXT_DOMAIN ); ?></div>

										<div class="wpmudev-listing-rates"><?php _e( "Conv. rate", Opt_In::TEXT_DOMAIN ); ?></div>

                                        <div class="wpmudev-listing-status"><?php _e( "Module status", Opt_In::TEXT_DOMAIN ); ?></div>

										<div class="wpmudev-listing-tracking"><?php _e( "Tracking", Opt_In::TEXT_DOMAIN ); ?></div>

									</div><?php // .wpmudev-listing-head ?>

									<div class="wpmudev-listing-body">

                                        <?php foreach( $types as $type ) : ?>

                                            <div class="wpmudev-listing-row">

                                                <div class="wpmudev-listing-type">

                                                    <p class="wpmudev-listing-title"><?php _e( "Module type", Opt_In::TEXT_DOMAIN ); ?></p>

                                                    <?php if ( $type === "floating_social" ) { ?>

                                                        <div class="wpmudev-listing-content">

                                                            <div class="wpmudev-listing-type-icon"><?php $this->render("general/icons/admin-icons/icon-floating" ); ?></div>

                                                            <span><?php _e( "Floating Social", Opt_In::TEXT_DOMAIN ); ?></span>

                                                        </div>

                                                    <?php } else if ( $type === "widget" ) { ?>

                                                        <div class="wpmudev-listing-content">

                                                            <div class="wpmudev-listing-type-icon"><?php $this->render("general/icons/admin-icons/icon-widget" ); ?></div>

                                                            <span><?php _e( "Widget", Opt_In::TEXT_DOMAIN ); ?></span>

                                                        </div>

                                                    <?php } else if ( $type === "shortcode" ) { ?>

                                                        <div class="wpmudev-listing-content">

                                                            <div class="wpmudev-listing-type-icon"><?php $this->render("general/icons/admin-icons/icon-shortcode" ); ?></div>

                                                            <span><?php _e( "Shortcode", Opt_In::TEXT_DOMAIN ); ?></span>

                                                        </div>

                                                    <?php } ?>

                                                </div>

                                                <div class="wpmudev-listing-conditions">

                                                    <p class="wpmudev-listing-title"><?php _e( "Display conditions", Opt_In::TEXT_DOMAIN ); ?></p>

                                                    <p class="wpmudev-listing-content">

														<?php if ( $type == 'floating_social' ) {
															echo $sshare->decorated->get_condition_labels(false);
														} else if ( $type == 'shortcode' ) {
															$shortcode = '[wd_hustle id=&quot;'. $sshare->shortcode_id .'&quot; type=&quot;social_sharing&quot;]';
															echo '<input type="text" value="' . $shortcode . '" readonly class="highlight_input_text shortcode_input">';
														} ?>

													</p>

                                                </div>

                                                <div class="wpmudev-listing-views">

                                                    <p class="wpmudev-listing-title"><?php _e( "Views", Opt_In::TEXT_DOMAIN ); ?></p>

                                                    <p class="wpmudev-listing-content"><?php echo $sshare->get_statistics($type)->views_count; ?></p>

                                                </div>

                                                <div class="wpmudev-listing-conversions">

                                                    <p class="wpmudev-listing-title"><?php _e( "Conversions", Opt_In::TEXT_DOMAIN ); ?></p>

                                                    <p class="wpmudev-listing-content"><?php echo $sshare->get_statistics($type)->conversions_count; ?></p>

                                                </div>

                                                <div class="wpmudev-listing-rates">

                                                    <p class="wpmudev-listing-title"><?php _e( "Conversions rate", Opt_In::TEXT_DOMAIN ); ?></p>

                                                    <p class="wpmudev-listing-content"><?php echo $sshare->get_statistics($type)->conversion_rate; ?>%</p>

                                                </div>

                                                <div class="wpmudev-listing-status">

                                                    <p class="wpmudev-listing-title"><?php _e( "Module status", Opt_In::TEXT_DOMAIN ); ?></p>

                                                    <div class="wpmudev-listing-content"><div class="wpmudev-tabs">

                                                        <ul class="wpmudev-tabs-menu wpmudev-tabs-menu_full">

															<li class="wpmudev-tabs-menu_item <?php echo ( !$sshare->is_sshare_type_active($type) && !$sshare->is_test_type_active( $type ) ) ? 'current' : '' ?>">
                                                                <input id="wph-module-<?php echo esc_attr($type) ."-". esc_attr( $sshare->id );  ?>-status--off" type="radio" value="off" name="wph-module-status" data-nonce="<?php echo wp_create_nonce('sshare_toggle_module_type_state'); ?>" data-type="<?php echo esc_attr($type); ?>" data-id="<?php echo esc_attr($sshare->id);  ?>" >
                                                                <label for="wph-module-<?php echo esc_attr($type) ."-". esc_attr( $sshare->id );  ?>-status--off" class="wpmudev-status-off"><?php _e( "Off", Opt_In::TEXT_DOMAIN ); ?></label>
                                                            </li>

                                                            <li class="wpmudev-tabs-menu_item <?php echo ( $sshare->is_test_type_active( $type ) ) ? 'current' : '' ?>">
                                                                <input id="wph-module-<?php echo esc_attr($type) ."-". esc_attr( $sshare->id );  ?>-status--test" type="radio" value="test" name="wph-module-status" data-nonce="<?php echo wp_create_nonce('sshare_toggle_test_activity'); ?>" data-type="<?php echo esc_attr($type); ?>" data-id="<?php echo esc_attr($sshare->id);  ?>" >
                                                                <label for="wph-module-<?php echo esc_attr($type) ."-". esc_attr( $sshare->id );  ?>-status--test" class="wpmudev-status-test"><?php _e( "Test", Opt_In::TEXT_DOMAIN ); ?></label>
                                                            </li>

                                                            <li class="wpmudev-tabs-menu_item <?php echo ( $sshare->is_sshare_type_active($type) && !$sshare->is_test_type_active( $type ) ) ? 'current' : '' ?>">
                                                                <input id="wph-module-<?php echo esc_attr($type) ."-". esc_attr( $sshare->id );  ?>-status--live" type="radio" value="live" name="wph-module-status" data-nonce="<?php echo wp_create_nonce('sshare_toggle_module_type_state'); ?>" data-type="<?php echo esc_attr($type); ?>" data-id="<?php echo esc_attr($sshare->id);  ?>">
                                                                <label for="wph-module-<?php echo esc_attr($type) ."-". esc_attr( $sshare->id );  ?>-status--live" class="wpmudev-status-live"><?php _e( "Live", Opt_In::TEXT_DOMAIN ); ?></label>
                                                            </li>

                                                        </ul>

                                                    </div></div>

                                                </div>

                                                <div class="wpmudev-listing-tracking">

                                                    <p class="wpmudev-listing-title"><?php _e( "Tracking", Opt_In::TEXT_DOMAIN ); ?></p>

                                                    <div class="wpmudev-switch">

                                                        <input id="social-sharing-toggle-tracking-<?php echo $type . '-' . esc_attr( $sshare->id ); ?>" class="social-sharing-toggle-tracking-activity" type="checkbox" data-id="<?php echo esc_attr( $sshare->id ) ?>" data-type="<?php echo esc_attr( $type ); ?>" <?php checked( $sshare->is_track_type_active( $type ), true); ?> data-nonce="<?php echo wp_create_nonce('sshare_toggle_tracking_activity') ?>" >

                                                        <label class="wpmudev-switch-design" for="social-sharing-toggle-tracking-<?php echo $type . '-' . esc_attr( $sshare->id ); ?>" aria-hidden="true"></label>

                                                    </div>

                                                </div>

                                            </div><?php // .wpmudev-listing-row ?>

                                        <?php endforeach; ?>

									</div><?php // .wpmudev-listing-body ?>

								</div><?php // .wpmudev-listing ?>

							</div><?php // .wpmudev-box-body ?>

                        </div>

                    </div>

                </div>

            <?php endforeach; ?>

        </section>

        <?php $this->render( "admin/commons/footer", array() ); ?>

        <?php $this->render("admin/commons/listing/delete-confirmation"); ?>

	</main>

<?php } ?>

<script>
(function($) {

	var item       = $('.wpmudev-list .wpmudev-list--element'),
		totalItems = item.length,
		itemCount  = totalItems;

	item.each(function() {

		$(this).css('z-index', itemCount);
		itemCount--;

		var dropdown	= $(this).find('.wpmudev-dots-dropdown'),
			button		= dropdown.find('.wpmudev-dots-button'),
			droplist	= dropdown.find('.wpmudev-dots-nav');

		droplist.addClass('wpmudev-hide');

		button.on('click', function(){
			$(this).toggleClass('wpmudev-active');
			droplist.toggleClass('wpmudev-hide');
		});

	});

}(jQuery));
</script>
